/**
 * This script will add markers at the specified interval
 *
 * Written By: Edward Troxel
 * www.jetdv.com/tts
 * Modified: 09-19-2003
 **/

import System;
import System.IO;
import System.Windows.Forms;
import Sony.Vegas;

//Change this value to be the desired interval
//Format:  hh:mm:ss:ff (hours:minutes:seconds:frames)
var Interval = "00:00:03:00";


try {
  var myMarker : Marker;
  var IncTime : Timecode = new Timecode(Interval);
  var CurrTime : Timecode = IncTime;
  var EndTime : Timecode = Vegas.Project.Length;

  while (CurrTime < EndTime) {
      //Put a marker at the interval point
      myMarker = new Marker(CurrTime);
      Vegas.Project.Markers.Add(myMarker);
      CurrTime = CurrTime + IncTime;
  }



} catch (e) {
    MessageBox.Show(e);
}

